

DEFINT A - Z

const PI = 3.141592654
option explicit                         'Force declaration


Type Vector3d
    x       as single
    y       as single
    z       as single
End Type

declare sub vector_cross (vout as vector3d, v1 as vector3d, v2 as vector3d )
declare function vector_magnitude(v as vector3d) as single
declare sub vector_normalize (v as vector3d)
declare sub vector_add (vout as vector3d, v1 as vector3d, v2 as vector3d )
declare sub vector_sub (vout as vector3d, v1 as vector3d, v2 as vector3d )

sub vector_cross ( vout as vector3d, v1 as vector3d, v2 as vector3d )
    vout.x = (v1.y * v2.z) - (v2.y * v1.z)
    vout.y = (v1.z * v2.x) - (v2.z * v1.x)
    vout.z = (v1.x * v2.y) - (v2.x * v1.y)
end sub

function vector_magnitude( v as vector3d ) as single
    dim mag as single
    mag = sqr(v.x * v.x + v.y * v.y + v.z * v.z)
    if mag = 0 then mag = 1
    vector_magnitude = mag
end function

sub vector_normalize ( v as vector3d )
    dim mag as single
    mag = vector_magnitude(v)
    v.x = v.x / mag
    v.y = v.y / mag
    v.z = v.z / mag
end sub


sub vector_add ( vout as vector3d, v1 as vector3d, v2 as vector3d )
    vout.x = v1.x + v2.x
    vout.y = v1.y + v2.y
    vout.z = v1.z + v2.z
end sub

sub vector_sub ( vout as vector3d, v1 as vector3d, v2 as vector3d )
    vout.x = v1.x - v2.x
    vout.y = v1.y - v2.y
    vout.z = v1.z - v2.z
end sub




